setwd("<your directory or folder path>")
df1 <- read.csv("20180711 Example 9.1 Logistic Regression.csv")
#
#
#
# VARIABLES:
# X.01
# X.02
# X.03
# X.04
# X.05
# X.06
# X.07
# X.08
# X.09
# X.10
# Binary
#

library(BMA)
library(glmulti)
library(nnet)
nbin <- nrow(df1)
testind <- rbinom(n=nbin,size=1,prob=0.1) 

df2 <- data.frame(cbind(df1,testind))

attach(df2)
dftest <- subset(df2,testind==1)
dftrain <- subset(df2,testind==0)


#
detach(df2)
attach(dftrain)

reg.names <- c("X.01","X.02","X.03","X.04","X.05","X.06","X.07","X.08","X.09","X.10")
prior.p <- c(0.9,0.001,0.9,0.001,0.001,0.9,0.9,0.9,0.9,0.001)
bma.model <- bic.glm(f=Binary ~ X.01 + X.02 + X.03 + X.04 + X.05 + X.06 + X.07 + X.08 + X.09 + X.10,data=dftrain,glm.family=binomial(),prior.param=prior.p)
nnet.model <- nnet(Binary~X.01+X.02+X.03+X.04+X.05+X.06+X.07+X.08+X.09+X.10,data=dftrain,size=5,skip=TRUE,linout=TRUE)
glm.model <- glm(Binary~X.01+X.02+X.03+X.04+X.05+X.06+X.07+X.08+X.09+X.10,family=binomial(link="logit"),data=dftrain)
step.model <- step(glm.model)
multi.model <- glmulti(glm.model,plotty=FALSE,report=FALSE,level=1,maxsize=10,method="g")

# Make some plots:
bma.predict <- predict(bma.model,dftrain)
nnet.predict <- predict(nnet.model,dftrain)
#nnet.predict <- nnet.model$fitted.values
step.predict <- 1 / (1 + exp(-predict(step.model,dftrain)))
#step.predict <- step.model$fitted.values
multi.big <- predict(multi.model)
multi.predict <- multi.big$averages
#multi.predict <- 1 / (1 + exp(-(predict(multi.model,dftrain))))
glm.predict <- 1 / (1 + exp(-predict(glm.model,dftrain)))
#glm.predict <- glm.model$fitted.values
#prediction <- multi.predict$averages
plot(x=glm.predict,y=nnet.predict,pch=1,xlab="Logistic Model",ylab="Predicted",main="Predicted Response vs. Logistic")
points(x=glm.predict,y=step.predict,pch=2)
points(x=glm.predict,y=multi.predict,pch=3)
points(x=glm.predict,y=bma.predict,pch=4)
#points(x=dftrain$Response,y=dftrain$Response,pch=4,type="b")
legend(x=0.1,y=1.05,legend=c("NNET","STEPWISE", "GLMULTI","BMA"),pch=c(1,2,3,4))
#
# dev.new() allows more plots to be made without overwriting previous plots
#
#summary(lm.model)
#lm.coeffs <- lm.model$coefficients
#step.coeffs <- step.model$coefficients
#multi.params <- coefficients(multi.model)
#multi.coeffs <- multi.params[,1]
detach(dftrain)
attach(dftest)
OOS.bma <- predict(bma.model,dftest)
OOS.nnet <- predict(nnet.model,dftest)
OOS.glm <- 1 / (1 + exp(-predict(glm.model,dftest)))
#OOS.lm <- lm.coeffs[1] + lm.coeffs[2]*X.01 + lm.coeffs[3]*X.02 + lm.coeffs[4]*X.03 + lm.coeffs[5]*X.04 + lm.coeffs[6]*X.05 + lm.coeffs[7]*X.06 + lm.coeffs[8]*X.07 + lm.coeffs[9]*X.08 + lm.coeffs[10]*X.09 + lm.coeffs[11]*X.10
OOS.step <- 1 / (1 + exp(-predict(step.model,dftest)))
multi.test <- predict(multi.model,,dftest)
OOS.multi <- multi.test$averages
dev.new()
plot(x=OOS.glm,y=OOS.nnet,pch=1,xlab="Logistic OOS",ylab="Predicted OOS",main="OOS Predicted Response vs. Logistic")
points(x=OOS.glm,y=OOS.step,pch=2)
points(x=OOS.glm,y=OOS.multi,pch=3)
points(x=OOS.glm,y=OOS.bma,pch=4)
#points(x=dftest$Response,y=dftest$Response,pch=4,type="b")
legend(x=0.1,y=0.85,legend=c("NNET","STEPWISE","GLMULTI","BMA"),pch=c(1,2,3,4))
row.X <- 1
test.X <- 1
meanX1.df <- data.frame(cbind(row.X,mean(X.01),mean(X.02),mean(X.03),mean(X.04),mean(X.05),mean(X.06),mean(X.07),mean(X.08),mean(X.09),mean(X.10),mean(Binary),test.X))
row.X <- 2
test.X <- 2
meanX2.df <- data.frame(cbind(row.X,mean(X.01),mean(X.02),mean(X.03),mean(X.04),mean(X.05),mean(X.06),mean(X.07),mean(X.08),mean(X.09),mean(X.10),mean(Binary),test.X))
meanX.df <- rbind(meanX1.df,meanX2.df)
names(meanX.df) <- c("row.names","X.01","X.02","X.03","X.04","X.05","X.06","X.07","X.08","X.09","X.10","Binary","testind")

center.bma <- predict(bma.model,newdata=meanX.df)
center.nnet <- predict(nnet.model,newdata=meanX.df)
center.step <- 1 / (1 + exp(-predict(step.model,newdata=meanX.df)))
center.multi <- predict(multi.model,newdata=meanX.df)
center.glm <- predict(glm.model,newdata=meanX.df)
center.glm <- 1 / (1 + exp(-predict(glm.model,newdata=meanX.df)))

diff.bma <- meanX.df$Binary[1] - center.bma[1]
diff.nnet <- meanX.df$Binary[1] - center.nnet[1]
diff.step <- meanX.df$Binary[1] - center.step[1]
diff.multi <- meanX.df$Binary[1] - center.multi$averages[1]
diff.glm <- meanX.df$Binary[1] - center.glm[1]



